/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLIVISHELL
#define WAYLANDBACKEND_WLIVISHELL 1

#include <string>
#include <wayland-client.h>
#include <wayland-client-protocol.h>
#include "WLInterface.hpp"
#include "ivi-application-client-protocol.h"
#include "WLShellInterface.hpp"

namespace WaylandBackend
{

class WLIVIShell : public WLShellInterface
{
public:
    WLIVIShell(struct wl_event_queue *eventQ);
    virtual ~WLIVIShell();

    int init(struct wl_registry* registry, uint32_t name,
                 const char* interface, uint32_t version);
    uint32_t getWLID();
    std::string& getWLName();

    std::string& getShellName() { return _shellName; }

    int surfaceCreate(struct wl_surface* wlSurface,
    					      unsigned int surfaceId,
                              void **shellSurface);

    int surfaceDestroy(void *shellSurface);
    
private:
    struct wl_event_queue*      _wlEventQ;
    uint32_t                    _wlID;
    std::string                 _wlInterfaceName;
    struct ivi_application*     _iviApplication;
    std::string                 _shellName;
    
    static const struct ivi_surface_listener surface_listener;
    
    static void handleSurfaceConfigure(void *data,
                             struct ivi_surface *ivi_surface,
                             int32_t width,
                             int32_t height);
};

}

#endif
